//
//  ViewController.swift
//  CoreLocation––SimulatingLocation
//
//  Created by Krishna Subramanian on 21/12/15.
//  Copyright © 2015 Krishna Subramanian. All rights reserved.
//

import UIKit
import CoreLocation
import MapKit

class ViewController: UIViewController, CLLocationManagerDelegate, MKMapViewDelegate {
  
  let locationManager = CLLocationManager()
  @IBOutlet weak var mapView: MKMapView!
  
  override func viewDidLoad() {
    super.viewDidLoad()
    
    self.locationManager.delegate = self
    
    if CLLocationManager.authorizationStatus() == .NotDetermined {
      self.locationManager.requestWhenInUseAuthorization()
    } else if CLLocationManager.authorizationStatus() != .AuthorizedWhenInUse {
      UIApplication.sharedApplication().openURL(NSURL(string: UIApplicationOpenSettingsURLString)!)
    }
    
    if CLLocationManager.locationServicesEnabled() {
      self.locationManager.startUpdatingLocation()
    }
    
    self.mapView.delegate = self
    self.mapView.showsUserLocation = true
    self.mapView.mapType = MKMapType.Satellite
    
    self.mapView.setCenterCoordinate(self.mapView.userLocation.coordinate, animated: true)
    
    // MKPinAnnotationView
    
    // Step 1: Create annotation object
    let informatikZentrum = CLLocationCoordinate2DMake(50.779447, 6.058796)
    let annotation = PinAnnotation(location: informatikZentrum, title: "Informatik Zentrum", subtitle: "Ahornstrasse 55, 52074 Aachen")
  }
  
  func mapView(mapView: MKMapView, viewForAnnotation annotation: MKAnnotation) -> MKAnnotationView? {
    if annotation.isKindOfClass(PinAnnotation) {
      
      // Step 2: Define annotation view
      let pinView = MKPinAnnotationView(annotation: annotation, reuseIdentifier: "PinAnnotation")
      
      pinView.pinColor = MKPinAnnotationColor.Purple
      pinView.canShowCallout = true
      
      return pinView
    }
    
    return nil
  }
  
  @IBAction func moveMap(sender: AnyObject) {
    // Get the current center
    var mapCenter = self.mapView.centerCoordinate
    
    // Move it to the left by half the width of the frame
    mapCenter = self.mapView.convertPoint(CGPointMake(1, self.mapView.frame.size.height/2.0), toCoordinateFromView: self.mapView)
    
    // Make the transition animated
    self.mapView.setCenterCoordinate(mapCenter, animated: true)
  }
  
  @IBAction func zoomIn(sender: AnyObject) {
    // Get the area currently displayed by the mapView
    var region = self.mapView.region
    
    // Change the span of the region
    region.span.latitudeDelta *= 0.5
    region.span.longitudeDelta *= 0.5
    
    // Set region with animation
    self.mapView.setRegion(region, animated: true)
  }
  
  override func didReceiveMemoryWarning() {
    super.didReceiveMemoryWarning()
    // Dispose of any resources that can be recreated.
  }


}

